#include "sendcmd.h"

#define DELAY(n) for(time=0; time<n; time++);

UBYTE InitSender( void )
{
  SendCmd( 0xff, 0x00, SCP_HIGH );
  return 0;
}

UBYTE SendCmd( UBYTE addr, UBYTE data, UBYTE prio )
{
  UWORD cmd, sreg;
  UBYTE *a=(UBYTE*) 0xA000;
  UBYTE i, ii, timer, time;

  #ifdef _DEBUG_
    static char MS_Buffer[16];
    sprintf(MS_Buffer,"%x%x  ", addr, data );
    set_bkg_tiles(0,0,strlen(MS_Buffer),1,(unsigned char*)MS_Buffer);
  #endif

  cmd = addr;
  cmd = cmd<<8 | data;

  if( !prio ) while( (*a&0x02) ) DELAY( 100 );
  *a = 0x02;            /* allocate line */

  for(ii=0; ii<6; ii++)
  {
    DELAY( 40 );          /* >800us, GAP */

    sreg = cmd;           /* get command to send */
    for(i=0; i<16; i++)   /* shift procedure */
    {
      if( sreg & 0x8000 )
        timer = 19;       /* 400us, log. 1 */
      else
        timer = 8;        /* 200us, log. 0 */

      *a = 0x03;          /* set line */
      DELAY( timer);
      *a = 0x02;          /* reset line */
      DELAY( timer );

      sreg = sreg << 1;
    }
  }

  *a = 0x00;

  return 0;
}  

